<?php 
    /**
    *
    * copyright (c) 2013-2024 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "include/costanti.php";
    include "include/util.php";
    include "gUtil/DbManager.php";
    include "gUtil/GestoreTabella.php";
    include "gUtil/Ricerca.php";
    include "classi/GeneratoreUrl.php";
    include "template/stile.php";
    include "classi/Tabella.php";
    include "classi/GestoreJavascript.php";
    include "template/include/includeClassiTemplate.php";

    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);		
    $gestoreJavascript = new GestoreJavascript();

    $impostazioni = recuperaImpostazioni($geecomDb);
    $configurazioneAspetto = $geecomDb->leggiSingolaRiga("geec_configurazioniAspetto", "si","selezionataAdmin");
    $inclusioni            = $geecomDb->leggiSingolaRiga("geecAd_inclusioni", 1);
    $tipo = filter_input(INPUT_GET,"tipo",FILTER_SANITIZE_ADD_SLASHES);

    session_start();
    if(!isset($_SESSION["geecomUser_email"]) ) {
        header("Location: index.php");
    }
    else {
	$utente = $geecomDb->leggiSingolaRIga("geec_utenti",$_SESSION["geecomUser_id"]);
    }
    
    $lingua = "italiano";
?>
<html>

<head>
    <meta charset="UTF-8">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta name="generator" content="Geecom Admin"/>
    <title><?php echo $impostazioni["nomePiattaforma"]; ?></title>

    <!-- Favicon-->
    <link rel="icon" href="favicon.ico" type="image/x-icon">
	
	<?php 
            include "include/includeCssBase.php";
	?>
    	<link rel="stylesheet" href="plugins/OwlCarousel2/assets/owl.carousel.min.css">
</head>

<body>
    <div class="wrapper">
        <?php
            include "template/include/menuPrincipale.php";
        ?>
        <!-- Contenuto principale  -->
        <div id="content" class="p-0 extramargin d-flex flex-column">
            <div class="page-wrapper">
                <?php
                    include "template/include/barraSuperiore.php";
                ?>
                <main class="p-4">
                        <div class="row">
	                <?php
	                    $visualizzatore = new VisualizzatoreComunicazioni($geecomDb,null);
	                    $visualizzatore->setImpostazioniRicerca($impostazioniRicerca);
	                    $visualizzatore->generaContenuto(["tipo"=>$tipo]);
	                ?>
                        </div>
                </main>
            </div>
        <?php
            include "template/include/footer.php";
        ?>
        </div>
    </div>
    <?php 
	 if($impostazioni["accessoFacebook"]=="si") {
            include "include/facebookSdk.php";
	 }

        include"include/includeJsBase.php"; 
        include"template/include/includeJsTemplate.php"; 
    ?>
    
    <script>
        function aggiungiAllegato() {
            if(document.getElementById("allegato2").className=="d-none") {
                document.getElementById("allegato2").className = "form-group";
            }
            else if(document.getElementById("allegato3").className=="d-none") {
                document.getElementById("allegato3").className = "form-group";
            }
            else if(document.getElementById("allegato3").className=="d-none") {
                document.getElementById("allegato3").className = "form-group";
            }
            else if(document.getElementById("allegato4").className=="d-none") {
                document.getElementById("allegato4").className = "form-group";
            }
            else if(document.getElementById("allegato5").className=="d-none") {
                document.getElementById("allegato5").className = "form-group";
                document.getElementById("pulsanteAggiungiAllegato").className = "btn btn-dark";
                document.getElementById("pulsanteAggiungiAllegato").disabled  = true;
            }
        }
        
        function inviaNuovoTicket() {
            var oggetto = document.getElementById("oggetto").value;
            var testo   = tinymce.activeEditor.getContent();
            
            if(oggetto=="") {
                alert("Inserisci l'oggetto");
            }
            else if(testo=="") {
                alert("Spiega il problema");
                alert("testo attuale:"+testo);
            }
            else if(oggetto.indexOf("<script>")>-1 || testo.indexOf("<script>")>-1) {
                alert("Attenzione: non puoi inserire script nei campi di testo");
            }
            else {
                document.getElementById("pulsanteCreaTicket").disabled = true;
                document.formCreaTicket.submit();
            }
        }
    </script>
</body>

</html>
